from datetime import date
import logging

from staff.headcounts.headcounts_credit_management.use_cases.interfaces import RepositoryInterface


logger = logging.getLogger(__name__)


class CloseUseCase:
    def __init__(self, repository: RepositoryInterface) -> None:
        self._repository = repository

    def close(self, credit_repayment_application_id: int) -> None:
        self._repository.close_application(credit_repayment_application_id)
        logger.info('Closed %s credit repayment application', credit_repayment_application_id)

    def deactivate_closed(self) -> None:
        applications = self._repository.closed_but_active_applications()

        for application in applications:
            if application.closed_at and application.closed_at.date() < date.today():
                self._repository.deactivate_application(application.id)
                logger.info('Deactivated application %s')
