import logging

from staff.lib.db import atomic

from staff.headcounts.headcounts_credit_management.use_cases.interfaces import (
    RepositoryInterface,
    Startrek,
    Workflows,
)


logger = logging.getLogger(__name__)


class CreateTicket:
    def __init__(self, startrek: Startrek, repository: RepositoryInterface, workflows: Workflows) -> None:
        self._startrek = startrek
        self._repository = repository
        self._workflows_gateway = workflows

    def create_missing_tickets(self) -> None:
        for credit_repayment in self._repository.applications_without_ticket():
            try:
                self.create_credit_repayment_ticket(credit_repayment)
            except Exception:
                logger.exception('Credit repayment ticket creation failed for %s', credit_repayment)

    @atomic
    def create_credit_repayment_ticket(self, credit_repayment):
        self._workflows_gateway.cancel_workflow(credit_repayment.id)

        ticket_key = self._startrek.create_ticket(credit_repayment)
        credit_repayment.ticket = ticket_key

        logger.info('Created ticket %s for credit application %s', ticket_key, credit_repayment.id)
        self._repository.save_credit_repayment(credit_repayment)
        self._workflows_gateway.create_workflow(credit_repayment)
