from datetime import datetime
from typing import List, Optional
from uuid import UUID

import attr


@attr.s(cmp=False, auto_attribs=True)
class CreateCreditRepaymentRequestRow:
    credit_budget_position_id: int
    repayment_budget_position_id: int


@attr.s(cmp=False, auto_attribs=True)
class CreateCreditRepaymentRequest:
    rows: List[CreateCreditRepaymentRequestRow]
    comment: str


@attr.s(cmp=False, auto_attribs=True)
class GeographyDescription:
    name: str
    oebs_code: str


@attr.s(cmp=False, auto_attribs=True)
class BudgetPosition:
    code: int
    department_url: Optional[str]
    hr_partner_login: Optional[str]
    hr_analyst_login: Optional[str]
    vacancy_id: Optional[int]
    valuestream: Optional[str]
    geography: Optional[GeographyDescription]


@attr.s(cmp=False, auto_attribs=True)
class CreditRepaymentRow:
    credit_budget_position: BudgetPosition
    repayment_budget_position: BudgetPosition
    workflow_id: Optional[UUID] = None


@attr.s(cmp=False, auto_attribs=True)
class CreditRepayment:
    rows: List[CreditRepaymentRow]
    comment: str
    author_login: str
    id: int
    ticket: Optional[str]
    is_active: Optional[bool]
    closed_at: Optional[datetime]

    @property
    def is_closed(self):
        return self.closed_at is not None
