from staff.headcounts.headcounts_credit_management.use_cases.errors import AccessDeniedError
from staff.headcounts.headcounts_credit_management.use_cases.interfaces import (
    RepositoryInterface,
    PermissionsInterface,
)
from staff.headcounts.headcounts_credit_management.use_cases import dto


class GetUseCase:
    def __init__(self, application_id: int, repository: RepositoryInterface, permissions: PermissionsInterface):
        self._permissions = permissions
        self._credit_repayment = repository.get_by_id(application_id)

    def has_access(self) -> bool:
        if not self._credit_repayment:
            return False

        return self._permissions.has_access_to_application(self._credit_repayment.author_login)

    def get(self) -> dto.CreditRepayment:
        if not self.has_access():
            raise AccessDeniedError

        return self._credit_repayment
