import abc
from typing import List

from staff.person.models import Staff
from staff.headcounts.headcounts_credit_management.use_cases import dto


class RepositoryInterface(metaclass=abc.ABCMeta):
    @abc.abstractmethod
    def save(self, create_repayment_request: dto.CreateCreditRepaymentRequest) -> int:
        pass

    @abc.abstractmethod
    def save_credit_repayment(self, credit_repayement: dto.CreditRepayment) -> None:
        pass

    @abc.abstractmethod
    def applications_without_ticket(self) -> List[dto.CreditRepayment]:
        pass

    @abc.abstractmethod
    def get_by_id(self, credit_repayment_application_id: int) -> dto.CreditRepayment:
        pass

    @abc.abstractmethod
    def close_application(self, credit_repayment_application_id: int) -> None:
        pass

    @abc.abstractmethod
    def closed_but_active_applications(self) -> List[dto.CreditRepayment]:
        pass

    @abc.abstractmethod
    def deactivate_application(self, credit_repayment_application_id: int) -> None:
        pass


class PermissionsInterface(metaclass=abc.ABCMeta):
    @abc.abstractmethod
    def has_special_role(self) -> bool:
        pass

    @abc.abstractmethod
    def has_access_to_application(self, author_login: str) -> bool:
        pass

    @abc.abstractmethod
    def can_create_applications(self, budget_position_ids: List[int]) -> bool:
        pass

    @abc.abstractmethod
    def can_confirm_applications(self) -> bool:
        pass

    @abc.abstractmethod
    def can_cancel_applications(self) -> bool:
        pass

    @abc.abstractmethod
    def person(self) -> Staff:
        pass


class Startrek(metaclass=abc.ABCMeta):
    @abc.abstractmethod
    def create_ticket(self, credit_repayment: dto.CreditRepayment) -> str:
        pass


class Workflows(metaclass=abc.ABCMeta):
    @abc.abstractmethod
    def create_workflow(self, credit_repayment: dto.CreditRepayment) -> None:
        pass

    @abc.abstractmethod
    def cancel_workflow(self, credit_repayment_id: int) -> None:
        pass
