# flake8: noqa

from staff.departments.models import Department, HeadcountPosition
from staff.headcounts.models import AllowedHeadcountOverdraft


def replace_tables_for_links(query: str):
    query.replace('intranet_department', Department._meta.db_table)
    query.replace('departments_headcountposition', HeadcountPosition._meta.db_table)
    query.replace('headcounts_allowedheadcountoverdraft', AllowedHeadcountOverdraft._meta.db_table)
    return query


# Fields order is IMPORTANT
_base_headcount_query_template = """
SELECT
    hc_sum.department_id as department_id,

    hc_sum.headcount, --total_hc,
    hc_sum.working, --current_count
    hc_sum.offers, --offers

    hc_sum.headcount - hc_sum.working - hc_sum.offers as balance,  -- current_balance

    hc_sum.vacancys, -- vacancy_open,

    hc_sum.vacancys_plan_new + hc_sum.vacancys_plan_replacement as vacancy_plan,
    hc_sum.vacancys_plan_new as vacancy_plan_new,
    hc_sum.vacancys_plan_replacement as vacancy_plan_replacement,

    hc_sum.credit, -- reserve_new

    hc_sum.working_crossing + hc_sum.offer_crossing + hc_sum.vacancy_plan_crossing + hc_sum.vacancy_crossing as crossing, -- crossheadcount
    hc_sum.working_crossing, -- replacement_to_working
    hc_sum.offer_crossing, -- offers_for_working_replacement
    hc_sum.vacancy_crossing, -- vacancy_open_for_working_replacement
    hc_sum.vacancy_plan_crossing, -- vacancy_plan_for_working_replacement

    COALESCE(overdrafts.percents_with_child_departments, CAST(0 as DECIMAL)) AS overdraft_percents_with_child

FROM (
        SELECT
            requested_dep.id as department_id,

            SUM(CASE
              WHEN pos.in_total_hc = TRUE THEN pos.headcount
              ELSE 0
            END) AS headcount,

            SUM(CASE
              WHEN pos.status = 'OCCUPIED' THEN pos.headcount
              ELSE 0
            END) AS working,

            SUM(CASE
              WHEN pos.status = 'OFFER' THEN pos.headcount
              ELSE 0
            END) AS offers,

            SUM(CASE
              WHEN pos.status = 'VACANCY_OPEN' THEN pos.headcount
              ELSE 0
            END) AS vacancys,

            SUM(CASE
              WHEN pos.status IN ('VACANCY_PLAN', 'RESERVE') AND pos.headcount > 0 AND pos.category_is_new = TRUE THEN pos.headcount
              ELSE 0
            END) AS vacancys_plan_new,

            SUM(CASE
              WHEN pos.status IN ('VACANCY_PLAN', 'RESERVE') AND pos.headcount > 0 AND pos.category_is_new = FALSE THEN pos.headcount
              ELSE 0
            END) AS vacancys_plan_replacement,

            SUM(CASE
              WHEN pos.status = 'RESERVE' AND pos.headcount < 0 THEN pos.headcount
              ELSE 0
            END) AS credit,

            SUM(CASE
              WHEN pos_cross.status = 'OCCUPIED' THEN pos.headcount
              ELSE 0
            END) AS working_crossing,

            SUM(CASE
              WHEN pos_cross.status = 'OFFER' THEN pos.headcount
              ELSE 0
            END) AS offer_crossing,

            SUM(CASE
              WHEN pos_cross.status = 'VACANCY_PLAN' THEN pos.headcount
              ELSE 0
            END) AS vacancy_plan_crossing,

            SUM(CASE
              WHEN pos_cross.status = 'VACANCY_OPEN' THEN pos.headcount
              ELSE 0
            END) AS vacancy_crossing

        FROM
            %(departments_from)s
            LEFT JOIN departments_headcountposition as pos_cross ON (
                pos_cross.code = pos.code and pos_cross.index = pos.next_index
            )
        GROUP BY requested_dep.id
    ) AS hc_sum
    LEFT JOIN headcounts_allowedheadcountoverdraft AS overdrafts ON (hc_sum.department_id = overdrafts.department_id)
;
"""

DEPARTMENTS_COUNTERS_QUERY = replace_tables_for_links(_base_headcount_query_template % {
    'departments_from': """
        intranet_department AS requested_dep
        INNER JOIN departments_headcountposition as pos ON (
            requested_dep.id in %s
            AND pos.department_id = requested_dep.id
        )
    """
})

VALUESTREAM_COUNTERS_QUERY = DEPARTMENTS_COUNTERS_QUERY.replace(
    'pos.department_id', 'pos.valuestream_id'
)

NESTED_DEPARTMENTS_COUNTERS_QUERY = replace_tables_for_links(_base_headcount_query_template % {
    'departments_from': """
        intranet_department AS requested_dep
        INNER JOIN intranet_department AS tree_dep ON (
            requested_dep.id in %s
            AND requested_dep.lft <= tree_dep.lft
            AND requested_dep.rght >= tree_dep.rght
            AND requested_dep.tree_id = tree_dep.tree_id
        )
        INNER JOIN departments_headcountposition as pos ON (
            pos.department_id = tree_dep.id
        )
    """
})

NESTED_VALUESTREAM_COUNTERS_QUERY = NESTED_DEPARTMENTS_COUNTERS_QUERY.replace(
    'pos.department_id', 'pos.valuestream_id'
)
