from staff.headcounts.headcounts_summary.query_builder.query_params import QueryParams
from staff.headcounts.headcounts_summary.query_builder.query_results import Result


class HierarchyLevelsFilter:
    def __init__(self, query_params: QueryParams) -> None:
        self._query_params = query_params

    def filter(self, result: Result) -> None:
        self._filter(result, 0)

    def _filter(self, result: Result, level: int) -> None:
        for next_level_grouping in result.next_level_grouping.values():
            self._filter(next_level_grouping, 0)

        if level == 0:
            for child in result.children.values():
                self._filter(child, level + 1)
        else:
            result.children = {}
