from staff.headcounts.headcounts_summary.query_builder.query_params import RelatedEntity


class Aliases:
    department_join = 'department_join'
    value_stream_join = 'valuestream_join'
    geography_join = 'geography_join'
    department_permissions_join = 'department_permissions_join'
    value_stream_permissions_join = 'value_stream_permissions_join'
    geography_permissions_join = 'geography_permissions_join'
    department_user_filter_join = 'department_user_filter_join'
    value_stream_user_filter_join = 'value_stream_user_filter_join'
    geography_user_filter_join = 'geography_user_filter_join'
    bp_table = 'bpa'
    next_bp_alias = 'bpan'
    prev_bp_alias = 'bpap'
    bp_code_table = 'bpc'
    summary_select_alias = 'summary_select'

    def join_alias(self, related_entity: RelatedEntity) -> str:
        if related_entity == RelatedEntity.department:
            return self.department_join
        elif related_entity == RelatedEntity.value_stream:
            return self.value_stream_join
        elif related_entity == RelatedEntity.geography:
            return self.geography_join
        else:
            assert False, 'Unsupported related entity'

    def ancestors_join_alias(self, related_entity: RelatedEntity) -> str:
        return f'{self.join_alias(related_entity)}_ancestors'
