from staff.departments.models import Department

from staff.headcounts.headcounts_summary.query_builder.aliases import Aliases
from staff.headcounts.headcounts_summary.query_builder.assignment_part_query_builder import (
    AssignmentPartQueryBuilder,
)
from staff.headcounts.headcounts_summary.query_builder.query_params import QueryParams
from staff.headcounts.headcounts_summary.query_builder.summary_query_builder import SummaryQueryBuilder


class QueryBuilder:
    department_table = Department._meta.db_table

    def __init__(self, query_params: QueryParams) -> None:
        assert len(query_params.groupings) == len(set(query_params.groupings))
        self.query_params = query_params
        self.aliases = Aliases()
        self._summary_query_builder = SummaryQueryBuilder(query_params, self.aliases, AssignmentPartQueryBuilder())

    def build(self) -> str:
        result = [
            self._select(),
            f'FROM ({self._summary_query_builder.build()}) as {self._summary_alias}',
            self._join_related_entities_info(),
            self._order_by(),
        ]
        return ' '.join(result)

    def _select(self) -> str:
        return f'SELECT {self._summary_alias}.*'

    @property
    def _summary_alias(self) -> str:
        return self.aliases.summary_select_alias

    def _join_related_entities_info(self) -> str:
        result = []
        for grouping in self.query_params.groupings:
            join_table_alias = self.aliases.join_alias(grouping)
            join = f'JOIN {self.department_table} AS {join_table_alias}'
            on = f'ON ({join_table_alias}.id = {self._summary_alias}.{grouping.pk_field_name})'
            result.append(f'{join} {on}')

        return ' '.join(result)

    def _order_by(self) -> str:
        if not self.query_params.groupings:
            return ''

        fields = []
        for grouping in self.query_params.groupings:
            join_table_alias = self.aliases.join_alias(grouping)
            fields.append(f'{join_table_alias}.lft')

        concatenated_fields = ', '.join(fields)
        return f'ORDER BY {concatenated_fields}'
