# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import django.core.validators


class Migration(migrations.Migration):

    dependencies = [
        ('django_intranet_stuff', '0001_initial'),
        ('budget_position', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='AllowedHeadcountOverdraft',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('percents_with_child_departments', models.DecimalField(verbose_name='Allowed overdraft in percents for department and its childs', null=True, max_digits=4, decimal_places=2)),
                ('department', models.OneToOneField(to='django_intranet_stuff.Department')),
            ],
        ),
        migrations.CreateModel(
            name='CreditManagementApplication',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('closed_at', models.DateTimeField(null=True)),
                ('comment', models.CharField(max_length=512)),
                ('startrek_headcount_key', models.CharField(max_length=32, blank=True, null=True, validators=[django.core.validators.RegexValidator(regex='^[A-Z]+-\\d+$', code='incorrect_key_format', message='Некорректный формат тикета')])),
                ('is_active', models.BooleanField(default=True)),
                ('author', models.ForeignKey(to='django_intranet_stuff.Staff')),
            ],
            options={
                'permissions': (('can_cancel_applications', 'Can cancel applications'), ('can_confirm_applications', 'Can confirm applications')),
            },
        ),
        migrations.CreateModel(
            name='CreditManagementApplicationRow',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('application', models.ForeignKey(related_name='rows', to='headcounts.CreditManagementApplication')),
                ('credit_budget_position', models.ForeignKey(to='budget_position.BudgetPosition')),
                ('repayment_budget_position', models.ForeignKey(related_name='+', to='budget_position.BudgetPosition')),
            ],
        ),
    ]
