from django.conf import settings

from staff.budget_position.workflow_service import WorkflowRegistryService
from staff.celery_app import app
from staff.lib.tasks import LockedTask
from staff.person.models import Staff

from staff.headcounts.headcounts_credit_management import CloseUseCase, CreateTicket, Repository, Startrek, Workflows


@app.task(ignore_result=True)
class DeactivateClosedApplications(LockedTask):
    def locked_run(self, *args, **kwargs):
        robot_staff = Staff.objects.get(login=settings.ROBOT_STAFF_LOGIN)
        repository = Repository(robot_staff)
        close_use_case = CloseUseCase(repository)
        close_use_case.deactivate_closed()


@app.task(ignore_result=True)
class CreateTicketForCreditRepaymentApplication(LockedTask):
    def locked_run(self):
        create_tickets_use_case = CreateTicket(Startrek(), Repository(None), Workflows(WorkflowRegistryService()))
        create_tickets_use_case.create_missing_tickets()
