from django.conf.urls import url

from staff.headcounts.views import (
    application,
    application_list,
    credit_management_application,
    move_to_maternity,
    occupation_by_logins,
    persons_by_vs,
    positions_by_vs,
    vs_by_persons,
    login_to_vs,
    summary,
    summary_export,
)


urlpatterns = [
    url(r'headcounts-summary/?$', summary, name='summary'),
    url(r'headcounts-summary/export/?$', summary_export, name='summary'),
    url(r'credit-management/?$', credit_management_application, name='credit_management'),
    url(r'credit-management/(?P<application_id>\d+)/?$', application, name='credit_management_application'),
    url(r'credit-management/list/?$', application_list, name='credit_management_list'),

    url(r'maternity/?$', move_to_maternity, name='move_to_maternity'),

    url(r'for-goals/persons-by-vs/?$', persons_by_vs, name='persons_by_vs'),
    url(r'for-goals/positions_by_vs/?$', positions_by_vs, name='positions_by_vs'),
    url(r'for-goals/vs-by-persons/?$', vs_by_persons, name='vs_by_persons'),
    url(r'for-goals/occupation_by_logins/?$', occupation_by_logins, name='occupation_by_logins'),
    url(r'login_to_vs/?$', login_to_vs, name='login_to_vs'),
]
