from datetime import datetime

from django.db import models


class DepartmentHeadcountSnapshot(models.Model):
    date_from = models.DateField(null=False)
    date_to = models.DateField(default=datetime.max)

    department = models.ForeignKey('django_intranet_stuff.Department', related_name='+')
    name = models.CharField(max_length=255)
    name_en = models.CharField(max_length=255, default='')

    total_hc = models.IntegerField(default=0)
    current_count = models.IntegerField(default=0)
    offers = models.IntegerField(default=0)
    current_balance = models.IntegerField(default=0)
    vacancy_open = models.IntegerField(default=0)
    vacancy_plan = models.IntegerField(default=0)
    vacancy_plan_new = models.IntegerField(default=0)
    vacancy_plan_replacement = models.IntegerField(default=0)
    reserve_new = models.IntegerField(default=0)
    crossheadcount = models.IntegerField(default=0)
    replacement_to_working = models.IntegerField(default=0)
    offers_for_working_replacement = models.IntegerField(default=0)
    vacancy_open_for_working_replacement = models.IntegerField(default=0)
    vacancy_plan_for_working_replacement = models.IntegerField(default=0)
    overdraft_percents_with_child = models.IntegerField(default=0)
