from datetime import date

from django.conf import settings

from staff.celery_app import app
from staff.lib.tasks import LockedTask

from staff.headcounts_history.snapshot import make_daily_snapshot


@app.task(ignore_result=True)
class MakeSnapshot(LockedTask):
    def locked_run(self, *args, **kwargs):
        make_daily_snapshot(date.today(), settings.YANDEX_DEPARTMENT_ID)
