from django_idm_api.exceptions import RoleNotFound
from staff.person.models import Staff

from staff.person.models import ResponsibleForRobot

from .base import BaseActions


def get_robot_qs():
    return Staff.objects.filter(is_robot=True)


class RobotActions(BaseActions):
    @staticmethod
    def get_objects(fields):
        robots = get_robot_qs().values(*fields)
        return robots


class RobotRoleActions(BaseActions):
    @staticmethod
    def _check_robot(robot_id):
        if not get_robot_qs().filter(id=robot_id).exists():
            raise RoleNotFound('Role "robot:%s" not found' % robot_id)

    def add_role(self, person_id, role):
        self._check_robot(role['robot'])
        created = ResponsibleForRobot.objects.get_or_create(
            robot_id=int(role['robot']),
            responsible_id=int(person_id),
            role=role['role']
        )[1]
        return created

    def remove_role(self, person_id, role):
        self._check_robot(role['robot'])
        qs = (
            ResponsibleForRobot.objects
            .filter(
                robot_id=int(role['robot']),
                responsible_id=int(person_id),
                role=role['role']
            )
        )
        for item in qs:
            item.delete()

    def get_all_roles(self):
        key_crumbs = dict(self.key_crumbs)
        qs = (
            ResponsibleForRobot.objects
            .filter(role=key_crumbs['role'])
            .values_list('responsible__login', 'robot_id')
        )

        for person_login, robot_id in qs:
            key_crumbs = dict(self.key_crumbs)
            key_crumbs['robot'] = str(robot_id)
            yield person_login, key_crumbs
