from django.db.models import Q

from staff.person.models import Staff

from staff.idm.base import BaseActions


class UserAttributeActionsBase(BaseActions):
    @staticmethod
    def set_state(person_id, role_info, state):
        role = role_info['user_attr']
        user = Staff.objects.select_related('user').get(id=person_id).user
        setattr(user, role, state)

        user.save()
        return True

    def add_role(self, person_id, role):
        return self.set_state(person_id, role, state=True)

    def remove_role(self, person_id, role):
        return self.set_state(person_id, role, state=False)

    def get_all_roles(self):
        key_crumbs = dict(self.key_crumbs)
        role = key_crumbs['user_attr']
        special_users = Staff.objects.filter(self._get_role_filter()).values_list('login', flat=True)

        for person_login in special_users:
            key_crumbs['user_attr'] = role

            yield person_login, key_crumbs

    def _get_role_filter(self):
        raise NotImplementedError


class UserAttributeActionsSuperuser(UserAttributeActionsBase):
    def _get_role_filter(self):
        return Q(user__is_superuser=True)


class UserAttributeActionsStaff(UserAttributeActionsBase):
    def _get_role_filter(self):
        return Q(user__is_staff=True)
