from django import forms

from staff.person.models import Staff
from staff.departments.models import Department
from .models import RECOMMENDATION_PROGRAM, GRADE_PROGRAM, PROFESSIONAL_LEVEL


class VacanciesFilterForm(forms.Form):
    department = forms.ModelChoiceField(
        Department.objects.all(),
        required=False,
        to_field_name='url',
    )
    chief = forms.ModelChoiceField(
        Staff.objects.all(),
        required=False,
        to_field_name='login',
    )
    recommendation_program = forms.CharField(
        required=False,
    )
    grade_program = forms.CharField(
        required=False,
    )
    professional_level = forms.CharField(
        required=False,
    )

    def clean_recommendation_program(self):
        recommendation_program = self.cleaned_data.get('recommendation_program')
        if recommendation_program:
            recommendation_program = [
                v for v in recommendation_program.split('|')
                if v in RECOMMENDATION_PROGRAM._text_values
            ]
        return recommendation_program

    def clean_grade_program(self):
        grade_program = self.cleaned_data.get('grade_program')
        if grade_program:
            grade_program = [
                v for v in grade_program.split('|')
                if v in GRADE_PROGRAM._text_values
            ]
        return grade_program

    def clean_professional_level(self):
        professional_level = self.cleaned_data.get('professional_level')
        if professional_level:
            professional_level = [
                v for v in professional_level.split('|')
                if v in PROFESSIONAL_LEVEL._text_values
            ]
        return professional_level
