# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('django_intranet_stuff', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Candidate',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('description_source', models.TextField(max_length=2048)),
                ('description', models.TextField(max_length=2048)),
                ('date_open', models.DateField(auto_now_add=True)),
                ('date_close', models.DateField(blank=True, null=True)),
                ('author', models.ForeignKey(null=True, related_name='candidate_info_author', to='django_intranet_stuff.Staff')),
                ('person', models.ForeignKey(related_name='candidate_info', to='django_intranet_stuff.Staff')),
            ],
        ),
        migrations.CreateModel(
            name='Profession',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('is_active', models.BooleanField(verbose_name='models.is_active-label', default=True)),
                ('name', models.CharField(verbose_name='Название', max_length=255)),
                ('name_en', models.CharField(verbose_name='Англ. название', max_length=255)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Vacancy',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('name', models.CharField(verbose_name='Название', max_length=512)),
                ('name_en', models.CharField(verbose_name='Англ. название', max_length=512, blank=True, default='')),
                ('description', models.TextField(verbose_name='Описание', max_length=6000)),
                ('description_en', models.TextField(verbose_name='Англ. описание', max_length=6000, blank=True, default='')),
                ('vacancy_url', models.URLField(verbose_name='Ссылка на вакансию', blank=True)),
                ('date_open', models.DateField(verbose_name='Дата открытия', auto_now_add=True)),
                ('date_close', models.DateField(verbose_name='Дата закрытия', blank=True, null=True)),
                ('reason', models.CharField(verbose_name='Причина закрытия', max_length=32, blank=True, null=True, choices=[('cancelled', 'Аннулирована'), ('internal_candidate', 'Внутренний кандидат'), ('external_candidate', 'Внешний кандидат')])),
                ('grade_program', models.CharField(verbose_name='Участие в программе рекоммендаций', max_length=32, default='not_participating', choices=[('not_participating', 'Не учавствует'), ('grade_3', 'Грейд 3'), ('grade_4', 'Грейд 4'), ('grade_5', 'Грейд 5'), ('grade_6', 'Грейд 6'), ('grade_7', 'Грейд 7'), ('grade_8', 'Грейд 8')])),
                ('recommendation_program', models.CharField(verbose_name='Участие в программе рекоммендаций (старое)', max_length=32, default='not_participating', choices=[('not_participating', 'Не учавствует'), ('regular_vacancy', 'Обычная'), ('medium_vacancy', 'Средняя'), ('complex_vacancy', 'Сложная')])),
                ('professional_level', models.CharField(verbose_name='Профессиональный уровень', max_length=32, default='none', choices=[('none', 'Не указан'), ('trainee', 'Стажёр'), ('junior', 'Младший'), ('middle', 'Специалист/руководитель'), ('senior', 'Старший'), ('lead', 'Ведущий'), ('expert', 'Эксперт')])),
                ('femida_link', models.CharField(max_length=255, null=True)),
                ('department', models.ForeignKey(verbose_name='Подразделение', to='django_intranet_stuff.Department')),
                ('profession', models.ForeignKey(verbose_name='Профессия', null=True, related_name='vacancies', to='innerhire.Profession')),
                ('recruiter', models.ForeignKey(verbose_name='Рекрутер', to='django_intranet_stuff.Staff')),
            ],
        ),
    ]
