from django.db import models
from staff.lib.models.base import SoftDeletedModel

from staff.lib.utils.ordered_choices import OrderedChoices


CANDIDATE_INFO_MAX_LEN = 256

REASON = OrderedChoices(
    ('CANCELLED', 'cancelled', 'Аннулирована'),
    ('INTERNAL_CANDIDATE', 'internal_candidate', 'Внутренний кандидат'),
    ('EXTERNAL_CANDIDATE', 'external_candidate', 'Внешний кандидат'),
)

RECOMMENDATION_PROGRAM = OrderedChoices(
    ('NONE', 'not_participating', 'Не учавствует'),
    ('REGULAR', 'regular_vacancy', 'Обычная'),
    ('MEDIUM', 'medium_vacancy', 'Средняя'),
    ('COMPLEX', 'complex_vacancy', 'Сложная'),
)

GRADE_PROGRAM = OrderedChoices(
    ('NONE', 'not_participating', 'Не учавствует'),
    ('GRADE_3', 'grade_3', 'Грейд 3'),
    ('GRADE_4', 'grade_4', 'Грейд 4'),
    ('GRADE_5', 'grade_5', 'Грейд 5'),
    ('GRADE_6', 'grade_6', 'Грейд 6'),
    ('GRADE_7', 'grade_7', 'Грейд 7'),
    ('GRADE_8', 'grade_8', 'Грейд 8'),
)

PROFESSIONAL_LEVEL = OrderedChoices(
    ('NONE', 'none', 'Не указан'),
    ('TRAINEE', 'trainee', 'Стажёр'),
    ('JUNIOR', 'junior', 'Младший'),
    ('MIDDLE', 'middle', 'Специалист/руководитель'),
    ('SENIOR', 'senior', 'Старший'),
    ('LEAD', 'lead', 'Ведущий'),
    ('EXPERT', 'expert', 'Эксперт'),
)


class Profession(SoftDeletedModel):
    """
    Справочник профессий для внутренних вакансий
    """

    name = models.CharField('Название', max_length=255)
    name_en = models.CharField('Англ. название', max_length=255)

    def __str__(self):
        return self.name

    # class Meta:
    #     verbose_name = 'профессию'
    #     verbose_name_plural = 'профессии'


class Vacancy(models.Model):

    # class Meta:
    #     verbose_name = 'Внутреннюю вакансию'
    #     verbose_name_plural = 'Внутренние вакансии'

    department = models.ForeignKey(
        'django_intranet_stuff.Department',
        verbose_name='Подразделение',
    )
    name = models.CharField(
        max_length=512,
        verbose_name='Название',
    )
    name_en = models.CharField(
        max_length=512,
        verbose_name='Англ. название',
        blank=True,
        default='',
    )
    description = models.TextField(
        max_length=6000,
        verbose_name='Описание',
    )
    description_en = models.TextField(
        max_length=6000,
        verbose_name='Англ. описание',
        blank=True,
        default='',
    )
    vacancy_url = models.URLField(
        blank=True,
        verbose_name='Ссылка на вакансию',
    )
    recruiter = models.ForeignKey(
        'django_intranet_stuff.Staff',
        verbose_name='Рекрутер',
    )
    date_open = models.DateField(
        auto_now_add=True,
        verbose_name='Дата открытия',
    )
    date_close = models.DateField(
        null=True,
        blank=True,
        verbose_name='Дата закрытия',
    )
    reason = models.CharField(
        choices=REASON,
        max_length=32,
        blank=True,
        null=True,
        verbose_name='Причина закрытия',
    )
    grade_program = models.CharField(
        choices=GRADE_PROGRAM,
        default=GRADE_PROGRAM.NONE,
        max_length=32,
        verbose_name='Участие в программе рекоммендаций',
    )
    recommendation_program = models.CharField(
        choices=RECOMMENDATION_PROGRAM,
        default=RECOMMENDATION_PROGRAM.NONE,
        max_length=32,
        verbose_name='Участие в программе рекоммендаций (старое)',
    )
    profession = models.ForeignKey(
        Profession,
        limit_choices_to={'is_active': True},
        null=True,
        related_name='vacancies',
        verbose_name='Профессия'
    )
    professional_level = models.CharField(
        choices=PROFESSIONAL_LEVEL,
        default=PROFESSIONAL_LEVEL.NONE,
        max_length=32,
        verbose_name='Профессиональный уровень',
    )
    # Primary key or the whole link
    femida_link = models.CharField(max_length=255, null=True)

    def __str__(self):
        return 'Vacancy: ' + self.name


class Candidate(models.Model):

    person = models.ForeignKey(
        'django_intranet_stuff.Staff',
        related_name='candidate_info',
    )
    author = models.ForeignKey(
        'django_intranet_stuff.Staff',
        related_name='candidate_info_author',
        null=True,
    )
    description_source = models.TextField(max_length=2048)
    description = models.TextField(max_length=2048)
    date_open = models.DateField(auto_now_add=True)
    date_close = models.DateField(null=True, blank=True)

    def __str__(self):
        return 'Candidate: ' + self.person.login


# TODO при увольнении автоматически закрывать
