from os import path
from json import dumps

from django.conf import settings
from django.http import HttpResponse

from . import get_status_bulk, get_status


def status(request, login):
    return HttpResponse(
        dumps(get_status(login)), content_type='text/javascript')


def status_bulk(request):
    logins = dict(request.GET.lists()).get('login', [])
    data = dumps(get_status_bulk(logins))

    callback = request.GET.get('callback', request.POST.get('callback', None))
    if callback:
        data = 'var data = %s; %s(data);' % (data, callback)

    return HttpResponse(data, content_type='text/javascript')


def status_png(request, login):
    jabber_status = get_status(login)

    if jabber_status not in (
            'available', 'away', 'chat', 'dnd',
            'none', 'offline', 'unavailable', 'xa'
    ):
        jabber_status = 'offline'
    filename = path.join(settings.MEDIA_ROOT, 'i', 'jabber', jabber_status+'.png')

    return HttpResponse(open(filename, 'rb').read(), content_type='image/png',)
