from django.contrib import admin

from staff.lib.utils.admin import StaffModelAdmin
from .models import GPGKey, BannedSSHKey
from .forms import GPGKeyAdminForm, BannedSSHAdminForm


class GPGKeyAdmin(StaffModelAdmin):
    list_display = ('staff', 'description', 'fingerprint', )

    form = GPGKeyAdminForm


class BannedSSHKeyAdmin(admin.ModelAdmin):
    list_display = ('description', 'fingerprint_sha256',)

    form = BannedSSHAdminForm


admin.site.register(GPGKey, GPGKeyAdmin)
admin.site.register(BannedSSHKey, BannedSSHKeyAdmin)
