import logging
from functools import partial
from datetime import datetime

audit_logger = logging.getLogger('keys.audit')


def log_key_updating(action, key_type, fingerprint, fingerprint_sha256, author_login, owner_login, ip):
    audit_logger.info(
        'timestamp="%s" src_ip="%s" src_user="%s" user="%s" '
        'type=%s fingerprint="%s" fingerprint_sha256="%s" action="%s"',
        int((datetime.now() - datetime.fromtimestamp(0)).total_seconds()),
        ip,
        author_login,
        owner_login,
        key_type,
        fingerprint,
        fingerprint_sha256,
        action,
    )


log_ssh_key_updating = partial(log_key_updating, key_type='ssh')
log_gpg_key_updating = partial(log_key_updating, key_type='gpg')
