from django.core.management.base import (
    BaseCommand,
    CommandError,
)

from staff.keys.models import GPGKey
from staff.person_profile.controllers import gpg_key


class Command(BaseCommand):
    help = 'Проверяет GPG ключи на соответствие правилам Стаффа'

    def handle(self, *args, **options):
        try:
            all_keys = GPGKey.objects.values('id', 'key', 'staff__login').all()
            for key in all_keys:
                try:
                    gpg_key.gpg_fingerprint(key['key'])
                except gpg_key.GPGKeyManyKeysError:
                    print('%s, key ID = %s' % (key['staff__login'], key['id']))
                except Exception:
                    pass
        except Exception as e:
            raise CommandError(e)
