from django.core.management.base import (
    BaseCommand,
    CommandError,
)

from staff.keys.models import SSHKey
from staff.person_profile.controllers.ssh_key import ssh_fingerprint


class Command(BaseCommand):
    help = 'Пересчитывает fingerprint у всех SSH ключей'

    def handle(self, *args, **options):
        try:
            all_keys = SSHKey.objects.all()
            for num, key in enumerate(all_keys):
                old_fpr_md5 = key.fingerprint
                old_fpr_sha256 = key.fingerprint_sha256
                try:
                    new_fpr_md5 = ssh_fingerprint(key.key)
                    new_fpr_sha256 = ssh_fingerprint(key.key, algo='sha256')
                    if new_fpr_md5 != old_fpr_md5 or new_fpr_sha256 != old_fpr_sha256:
                        key.fingerprint = new_fpr_md5
                        key.fingerprint_sha256 = new_fpr_sha256
                        key.save()

                    if not num % 500:
                        print('Complete %s keys...' % num)
                except Exception as e:
                    print('Problem: %s' % key.id, e)
        except Exception as e:
            raise CommandError(e)
