# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('django_intranet_stuff', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='BannedSSHKey',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('description', models.CharField(max_length=255, blank=True, default='')),
                ('key', models.TextField(default='')),
                ('fingerprint_sha256', models.CharField(max_length=100, unique=True, default='')),
            ],
            options={
                'db_table': 'intranet_staff_banned_key',
            },
        ),
        migrations.CreateModel(
            name='GPGKey',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('description', models.TextField(blank=True, default='')),
                ('key', models.TextField(default='')),
                ('fingerprint', models.CharField(max_length=100, db_index=True, default='')),
                ('staff', models.ForeignKey(related_name='gpg_keys', to='django_intranet_stuff.Staff')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SSHKey',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('description', models.CharField(max_length=255, blank=True, default='')),
                ('key', models.TextField(default='')),
                ('fingerprint', models.CharField(max_length=100, default='')),
                ('fingerprint_sha256', models.CharField(max_length=100, db_index=True, default='')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(db_index=True, auto_now=True)),
                ('intranet_status', models.IntegerField(default=1)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('staff', models.ForeignKey(related_name='ssh_keys', to='django_intranet_stuff.Staff')),
            ],
            options={
                'db_table': 'intranet_staff_key',
            },
        ),
    ]
