from django.db import models
from staff.lib.models.base import AtomicSaveModel


class GPGKey(AtomicSaveModel):
    staff = models.ForeignKey('django_intranet_stuff.Staff',
                              related_name='gpg_keys')
    description = models.TextField(blank=True, default='')
    key = models.TextField(default='')
    fingerprint = models.CharField(default='', max_length=100, db_index=True)

    def __str__(self):
        return '%s: %s' % (self.staff, self.description)


class SSHKey(AtomicSaveModel):
    staff = models.ForeignKey(
        'django_intranet_stuff.Staff',
        related_name='ssh_keys',
    )
    description = models.CharField(blank=True, max_length=255, default='')
    key = models.TextField(default='')
    fingerprint = models.CharField(default='', max_length=100)
    fingerprint_sha256 = models.CharField(default='', max_length=100, db_index=True)
    created_at = models.DateTimeField(editable=False, auto_now_add=True)
    modified_at = models.DateTimeField(editable=False, auto_now=True, db_index=True)

    intranet_status = models.IntegerField(default=1)
    native_lang = models.CharField(max_length=2, default='', blank=True)

    def __str__(self):
        return '%s: %s' % (self.staff, self.description)

    class Meta:
        db_table = 'intranet_staff_key'


class BannedSSHKey(models.Model):
    description = models.CharField(blank=True, max_length=255, default='')
    key = models.TextField(default='')
    fingerprint_sha256 = models.CharField(unique=True, default='', max_length=100)

    def __str__(self):
        return '%s' % self.description

    class Meta:
        db_table = 'intranet_staff_banned_key'
