# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('django_intranet_stuff', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Log',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('created_at', models.DateTimeField(verbose_name='models.created_at-label', auto_now_add=True)),
                ('modified_at', models.DateTimeField(verbose_name='models.modified_at-label', auto_now=True)),
                ('message', models.CharField(max_length=255, default='')),
                ('power', models.DecimalField(max_digits=14, decimal_places=4)),
                ('issuer', models.ForeignKey(related_name='kudos_given', to='django_intranet_stuff.Staff')),
                ('recipient', models.ForeignKey(related_name='kudos_taken', to='django_intranet_stuff.Staff')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Stat',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('created_at', models.DateTimeField(verbose_name='models.created_at-label', auto_now_add=True)),
                ('modified_at', models.DateTimeField(verbose_name='models.modified_at-label', auto_now=True)),
                ('score', models.DecimalField(default=0, max_digits=14, decimal_places=4)),
                ('person', models.OneToOneField(related_name='kudos', to='django_intranet_stuff.Staff')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
