from django.db import models
from django.utils.encoding import python_2_unicode_compatible

from staff.lib.models.base import TimeStampedModel
from staff.lib.utils.library import Library
from staff.person.models import Staff

library_kudos = Library(lambda x: x.__name__)

DECIMAL_KWARGS = dict(max_digits=14, decimal_places=4)


@library_kudos.register
@python_2_unicode_compatible
class Stat(TimeStampedModel):
    """Статистика благодарностей по пользователям."""

    person = models.OneToOneField(Staff, related_name='kudos')
    score = models.DecimalField(default=0, **DECIMAL_KWARGS)  # Набранная благодарность.

    def __str__(self):
        return '%s: %s' % (self.person_id, self.score)


@library_kudos.register
@python_2_unicode_compatible
class Log(TimeStampedModel):
    """Журнал выдачи благодарности."""

    issuer = models.ForeignKey(Staff, related_name='kudos_given', on_delete=models.CASCADE)
    recipient = models.ForeignKey(Staff, related_name='kudos_taken', on_delete=models.CASCADE)
    message = models.CharField(max_length=255, default='')  # Пользовательская заметка к благодарности.
    power = models.DecimalField(**DECIMAL_KWARGS)  # Сила благодарности.

    def __str__(self):
        return '%s -> %s: %s' % (self.issuer_id, self.recipient_id, self.power)
