from django.contrib import admin

from staff.lib.utils.admin import StaffModelAdmin

from .models import LentaLog, CountAndGrowth


class LentaLogAdmin(StaffModelAdmin):
    list_display = ('staff', 'action', 'created_at')
    fields = (
        'staff',
        'action',
        ('position_old', 'position_new'),
        ('headcount_old', 'headcount_new'),
        ('department_old', 'department_new'),
        ('office_old', 'office_new'),
        ('organization_old', 'organization_new'),
        'created_at'
    )
    readonly_fields = ('created_at', )
    ordering = ('-created_at', )


class CountAndGrowthAdmin(StaffModelAdmin):
    list_display = (
        'created_at',
        'office',
        'organization',
        'department_0',
        'department_1',
        'department_2',
        'headcount',
        'total',
        'hired',
        'fired',
        'returned',
        'joined',
        'left',
    )


admin.site.register(LentaLog, LentaLogAdmin)
admin.site.register(CountAndGrowth, CountAndGrowthAdmin)
