from django import forms

from staff.departments.models import Department
from staff.map.models import City

from staff.lib.utils.ordered_choices import OrderedChoices

from .models import CountAndGrowth


COUNTRIES_BY = OrderedChoices('organization', 'office')
GROUP_BY = OrderedChoices('city', 'country')

DEP_0_QS = Department.objects.filter(
    id__in=CountAndGrowth.objects.values('department_0_id')
)
DEP_1_QS = Department.objects.filter(
    id__in=CountAndGrowth.objects.values('department_1_id')
)
CITIES_QS = City.objects.all()


class ChartForm(forms.Form):
    # Required fields
    countries_by = forms.ChoiceField(COUNTRIES_BY)
    department_0 = forms.ModelChoiceField(DEP_0_QS)

    # Optional fields
    department_1 = forms.ModelChoiceField(DEP_1_QS, required=False)
    with_homies = forms.BooleanField(required=False)
    only_headcount = forms.BooleanField(required=False)
    start = forms.DateField(required=False)
    end = forms.DateField(required=False)
    step = forms.IntegerField(min_value=1, max_value=100, required=False)
    cities = forms.ModelMultipleChoiceField(CITIES_QS, required=False)
    group_by = forms.ChoiceField(GROUP_BY, required=False)


class FreeChartForm(ChartForm):
    countries_by = forms.ChoiceField(COUNTRIES_BY, required=False)
    department_0 = forms.ModelChoiceField(DEP_0_QS, required=False)


LENTA_ACTION_TYPES = OrderedChoices('hired', 'dismissed', 'changed')


class LentaParamsForm(forms.Form):
    action_type = forms.ChoiceField(LENTA_ACTION_TYPES, required=False)
    continuation_token = forms.IntegerField(min_value=1, required=False)
    department_id = forms.IntegerField(min_value=1, required=False)
    ignore_descendants = forms.BooleanField(required=False)
