# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('django_intranet_stuff', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='CountAndGrowth',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('created_at', models.DateField()),
                ('headcount', models.BooleanField(default=False)),
                ('total', models.IntegerField(verbose_name='изменение общей численности')),
                ('hired', models.IntegerField(verbose_name='число нанятых')),
                ('fired', models.IntegerField(verbose_name='число уволенных')),
                ('returned', models.IntegerField(verbose_name='число вернувшихся')),
                ('joined', models.IntegerField(verbose_name='число переведённых +')),
                ('left', models.IntegerField(verbose_name='число переведённых -')),
                ('department_0', models.ForeignKey(related_name='countandgrowth_set_dep0', to='django_intranet_stuff.Department')),
                ('department_1', models.ForeignKey(null=True, related_name='countandgrowth_set_dep1', to='django_intranet_stuff.Department')),
                ('department_2', models.ForeignKey(null=True, related_name='countandgrowth_set_dep2', to='django_intranet_stuff.Department')),
                ('office', models.ForeignKey(to='django_intranet_stuff.Office')),
                ('organization', models.ForeignKey(to='django_intranet_stuff.Organization')),
            ],
        ),
        migrations.CreateModel(
            name='LentaLog',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('action', models.CharField(max_length=1, choices=[('h', 'staff.lenta.action-hired'), ('d', 'staff.lenta.action-dismissed'), ('c', 'staff.lenta.action-changed-position'), ('t', 'staff.lenta.action-transferred'), ('x', 'staff.lenta.action-transferred-and-changed-position'), ('r', 'staff.lenta.action-returned'), ('m', 'staff.lenta.action-moved'), ('o', 'staff.lenta.action-changed_organization'), ('e', 'Changed Headcount')])),
                ('created_at', models.DateTimeField(db_index=True, auto_now_add=True)),
                ('position_old', models.CharField(max_length=150, blank=True, default='')),
                ('position_new', models.CharField(max_length=150, default='')),
                ('department_new_path', models.CharField(max_length=100, default='')),
                ('headcount_old', models.BooleanField(default=False)),
                ('headcount_new', models.BooleanField(default=False)),
                ('department_new', models.ForeignKey(null=True, related_name='lenta_log_hired', to='django_intranet_stuff.Department')),
                ('department_old', models.ForeignKey(blank=True, null=True, related_name='lenta_log_dismissed', to='django_intranet_stuff.Department')),
                ('office_new', models.ForeignKey(null=True, related_name='lenta_log_office_new', to='django_intranet_stuff.Office')),
                ('office_old', models.ForeignKey(blank=True, null=True, related_name='lenta_log_office_old', to='django_intranet_stuff.Office')),
                ('organization_new', models.ForeignKey(null=True, related_name='lenta_log_office_new', to='django_intranet_stuff.Organization')),
                ('organization_old', models.ForeignKey(blank=True, null=True, related_name='lenta_log_office_old', to='django_intranet_stuff.Organization')),
                ('staff', models.ForeignKey(to='django_intranet_stuff.Staff')),
            ],
            options={
                'db_table': 'lenta_log',
                'ordering': ('-created_at',),
            },
        ),
        migrations.AlterUniqueTogether(
            name='countandgrowth',
            unique_together=set([('created_at', 'headcount', 'office', 'organization', 'department_0', 'department_1', 'department_2')]),
        ),
    ]
