from django.db import models
from django.utils.translation import ugettext_lazy as _

from staff.lib.utils import ordered_choices


class ACTION_CHOICES(ordered_choices.StaffChoices):
    HIRED = ('h', _('staff.lenta.action-hired'))
    DISMISSED = ('d', _('staff.lenta.action-dismissed'))
    CHANGED_POSITION = ('c', _('staff.lenta.action-changed-position'))
    TRANSFERRED = ('t', _('staff.lenta.action-transferred'))
    TRANSFERRED_AND_CHANGED_POSITION = ('x', _('staff.lenta.action-transferred-and-changed-position'))
    RETURNED = ('r', _('staff.lenta.action-returned'))
    MOVED = ('m', _('staff.lenta.action-moved'))
    CHANGED_ORGANIZATION = ('o', _('staff.lenta.action-changed_organization'))
    CHANGED_HEADCOUNT = ('e', 'Changed Headcount')


LAST_RECORDS_LIMIT = 100


class LentaLog(models.Model):
    """
    Модель для хранения кадровых изменений, которые нужно отображать в ленте
    """
    action = models.CharField(max_length=1, choices=ACTION_CHOICES.choices())
    staff = models.ForeignKey('django_intranet_stuff.Staff')
    created_at = models.DateTimeField(auto_now_add=True, db_index=True)

    position_old = models.CharField(max_length=150, default='', blank=True,)
    position_new = models.CharField(max_length=150, default='')

    department_new_path = models.CharField(max_length=100, default='')
    department_old = models.ForeignKey(
        'django_intranet_stuff.Department',
        related_name='lenta_log_dismissed',
        null=True,
        blank=True,
    )
    department_new = models.ForeignKey(
        'django_intranet_stuff.Department',
        related_name='lenta_log_hired',
        null=True,
    )

    office_old = models.ForeignKey(
        'django_intranet_stuff.Office',
        related_name='lenta_log_office_old',
        null=True,
        blank=True,
    )
    office_new = models.ForeignKey(
        'django_intranet_stuff.Office',
        related_name='lenta_log_office_new',
        null=True,
    )

    organization_old = models.ForeignKey(
        'django_intranet_stuff.Organization',
        related_name='lenta_log_office_old',
        null=True,
        blank=True,
    )
    organization_new = models.ForeignKey(
        'django_intranet_stuff.Organization',
        related_name='lenta_log_office_new',
        null=True,
    )

    headcount_old = models.BooleanField(default=False)
    headcount_new = models.BooleanField(default=False)

    class Meta:
        db_table = 'lenta_log'
        ordering = ['-created_at', '-id']


FK_FIELDS = 'office', 'organization', 'department_0', 'department_1', 'department_2'
KEY_FIELDS = ('created_at', 'headcount') + FK_FIELDS


class CountAndGrowth(models.Model):
    FK_FIELDS = FK_FIELDS
    KEY_FIELDS = KEY_FIELDS
    VALUE_FIELDS = 'total', 'hired', 'fired', 'returned', 'joined', 'left'
    ALL_FIELDS = KEY_FIELDS + VALUE_FIELDS

    created_at = models.DateField()
    office = models.ForeignKey('django_intranet_stuff.Office')
    organization = models.ForeignKey('django_intranet_stuff.Organization')
    department_0 = models.ForeignKey('django_intranet_stuff.Department', related_name='countandgrowth_set_dep0')
    department_1 = models.ForeignKey(
        'django_intranet_stuff.Department',
        related_name='countandgrowth_set_dep1',
        null=True,
    )
    department_2 = models.ForeignKey(
        'django_intranet_stuff.Department',
        related_name='countandgrowth_set_dep2',
        null=True,
    )
    headcount = models.BooleanField(default=False)

    total = models.IntegerField(verbose_name='изменение общей численности')
    hired = models.IntegerField(verbose_name='число нанятых')
    fired = models.IntegerField(verbose_name='число уволенных')
    returned = models.IntegerField(verbose_name='число вернувшихся')
    joined = models.IntegerField(verbose_name='число переведённых +')
    left = models.IntegerField(verbose_name='число переведённых -')

    class Meta:
        unique_together = KEY_FIELDS
