from django.contrib.auth.decorators import permission_required
from django.http import HttpResponse

from staff.lib.decorators import responding_xlsx

from .objects import LentaReport, HeadcountReport
from .forms import CreateLentaReportForm


@permission_required(
    'django_intranet_stuff.can_view_lenta_report',
    raise_exception=True)
@responding_xlsx(prefix='lenta-report')
def lenta_report(request):

    form = CreateLentaReportForm(data=request.GET.dict())
    if not form.is_valid():
        return HttpResponse(str(form.errors))

    return [LentaReport(**form.cleaned_data).as_table()]


@permission_required(
    'django_intranet_stuff.can_view_headcount_report',
    raise_exception=True)
@responding_xlsx(prefix='headcount-report')
def headcount_report(request):

    form = CreateLentaReportForm(data=request.GET.dict())
    if not form.is_valid():
        return HttpResponse(str(form.errors))

    return [HeadcountReport(**form.cleaned_data).as_table()]
