from datetime import datetime, date, timedelta, time
import logging

from staff.celery_app import app

from staff.lib.tasks import LockedTask

from .objects import Aggregator
from .models import CountAndGrowth

logger = logging.getLogger(__name__)


@app.task(ignore_result=True)
class CountLenta(LockedTask):
    def locked_run(self, *args, **kwargs):
        today = date.today()
        yesterday = today - timedelta(days=1)
        yesyesterday = today - timedelta(days=2)
        start = datetime.combine(yesyesterday, time())
        end = datetime.combine(yesterday, time())

        logger.info('Gonna calculate lenta counters for period [%s; %s]',
                    start, end)

        aggregator = Aggregator(start, end)
        count = aggregator.run()

        logger.info('Calculated %s lenta counters for period [%s; %s]',
                    count, start, end)


@app.task(ignore_result=True)
class RecalculateCountAndGrowth(LockedTask):
    def locked_run(self, *args, **kwargs):
        CountAndGrowth.objects.all().delete()

        start = datetime(1990, 1, 1)
        end = date.today()

        logger.info('Gonna calculate lenta counters for period [%s; %s]',
                    start, end)

        aggregator = Aggregator(start, end)
        count = aggregator.run()

        logger.info('Calculated %s lenta counters for period [%s; %s]',
                    count, start, end)
