import re
from datetime import datetime

# log_format toolsformat '[$time_local] $http_host $remote_addr "$request"
# $status "$http_referer" "$http_user_agent" "$cookie_yandex_login"
# "yandexuid=$cookie_yandexuid" $request_time
# $upstream_cache_status $bytes_sent';
TOOLS_LOG_FORMAT_RE = re.compile(r'^\[(?P<time_local>.*)\] '
                                 r'(?P<http_host>\S+) '
                                 r'(?P<remote_addr>[.:0-9a-fA-F]+) '
                                 r'"(?P<request>.+)" '
                                 r'(?P<status>[0-9]{3}) '
                                 r'"(?P<http_referer>.+)" '
                                 r'"(?P<http_user_agent>.+)" '
                                 r'"(?P<cookie_yandex_login>.+)" '
                                 r'"yandexuid=(?P<cookie_yandexuid>.+)" '
                                 r'(?P<request_time>\S+) '
                                 r'(?P<upstream_cache_status>\S+) '
                                 r'(?P<bytes_sent>\S+)$')


def parse_log_entry(log_entry):
    log_dict = log_entry_to_dict(log_entry)
    if log_dict is None:
        return

    log_dict['time_local'] = convert_datetime(datetime_str=log_dict['time_local'])
    convert_null_values(log_dict)

    return log_dict


def log_entry_to_dict(log_entry):
    matches = TOOLS_LOG_FORMAT_RE.search(log_entry)
    return matches and matches.groupdict()


def convert_datetime(datetime_str):
    datetime_str = datetime_str.split()[0]
    DATETIME_FORMAT = '%d/%b/%Y:%H:%M:%S'
    return datetime.strptime(datetime_str, DATETIME_FORMAT)


def convert_null_values(log_dict):
    for key, value in log_dict.items():
        if value == '-':
            log_dict[key] = None

    return log_dict
