from django.http import HttpResponse
from django.template import Context, Template
from django.conf.urls import patterns, url


class Collection(object):

    doc_url = None

    def __init__(self, help, doc_url=None, require_permissions=(), formats=()):
        self.help = help
        self.doc_url = doc_url
        self.require_permissions = require_permissions
        self.methods = []
        self.formats = formats

    def django_patterns(self):
        urls = sum((meth.django_urls() for meth in self.methods), [])

        if self.doc_url is not None:
            urls.append(url(self.doc_url, self.dochandler))

        return patterns('', *urls)

    def register(self, cls):
        """
        Decorator for adding API methods to collection.
        """
        # TODO: proper error
        assert not getattr(cls, '__collection__', None)

        cls.__collection__ = self
        self.methods.append(cls)
        return cls

    def docstr(self):
        cntx = dict(
            help=self.help,
            methods=[{'url': m.url, 'help': m.docstr()} for m in self.methods]
        )
        return collection_doc_tmpl.render(Context(cntx))

    def docview(self):
        return HttpResponse(self.docstr(), content_type="text/plain")

    def dochandler(self, request, *args, **kwargs):
        return self.docview()


collection_doc_tmpl_str = """
{{ help }}

{% for meth in methods %}
   {{ meth.help }}
===========================

{% endfor %}
"""

collection_doc_tmpl = Template(collection_doc_tmpl_str)
