class ApiResponse(Exception):
    key = 'content'
    code = 200
    # Failure code (string)
    reason = None
    # Human-readable message
    message = None
    data = None

    def __init__(self, message=None, code=None, reason=None, data=None):
        if code:
            self.code = code
        if reason:
            self.reason = reason
        if message:
            self.message = message
        if data:
            self.data = data

    def gen_content(self):
        d = dict()
        d[self.key] = self.data or []
        if self.reason:
            d['error_code'] = self.reason
        return d

    def __str__(self):
        return "<{0.code}: {0.reason}>".format(self)


class ApiError(ApiResponse):
    key = 'errors'

    @property
    def reason(self):
        return self.__class__.__name__


class CustomResponse(ApiResponse):
    code = 200

    def __init__(self, response_dict, code=None):
        self.response_dict = response_dict
        if code:
            self.code = code

    def gen_content(self):
        return self.response_dict
