from .base import BaseAnonymousAuthMechanism


class Mechanism(BaseAnonymousAuthMechanism):
    """
    Несколько ручек доступных без аутентификации.
    """

    ANONYMOUS_AVAILABLE_PATHS = [
        '/_check/',
        '/whistlah/office_by_ip/',
        '/center/api/xmlrpc',  # в самой ручке проверяется сеть откуда пришли, искать по ALLOWED_NETWORKS
        '/headcounts-api/credit-management/st-trigger/',
        '/budget-position-api/push-to-oebs/',
    ]

    def is_valid(self, request):
        for path in self.ANONYMOUS_AVAILABLE_PATHS:
            if request.path.startswith(path):
                return True
        return False
