from django_yauth.authentication_mechanisms.base import BaseMechanism


class AuthenticatedAnonymousYandexUser(BaseMechanism.AnonymousYandexUser):
    """
    Класс *анонимного* yauser-пользователя,
    у которого is_authenticated() вернёт True
    т.к. в конкретном случае механизм аутентификации пройден.
    При этом поведение request.user не меняется
    """
    def is_authenticated(self):
        return True


class BaseAnonymousAuthMechanism(BaseMechanism):
    AnonymousYandexUser = AuthenticatedAnonymousYandexUser
    is_impersonated = False

    def is_valid(self, request):
        raise NotImplementedError

    def extract_params(self, request):
        if self.is_valid(request):
            return {'mechanism': self}
        return None

    def apply(self, **kwargs):
        yauser = self.AnonymousYandexUser(**kwargs)
        yauser.is_impersonated = self.is_impersonated
        return yauser
