from staff.django_api_auth.checkers import token_is_valid
from .base import BaseAnonymousAuthMechanism


class Mechanism(BaseAnonymousAuthMechanism):
    """
    В Центровых ручках аутентификация проверяется по связке токен + ip
    Доступ к таким ручкам ограничен в AccessMiddleware
    """

    def is_valid(self, request):
        return token_is_valid(request)
