class AuthException(Exception):
    """
    Базовый класс для исключений аутентификации.
    """
    pass


class NoRealIP(AuthException):
    """
    Невозможно определить IP пользователя.
    Попробуйте настроить ваш nginx, чтобы пробрасывал вам правильные заголовки.
    """


class UserNotFoundError(AuthException):
    """
    Не удалось найти Django User.
    """


class PersonNotFound(AuthException):
    """
    Не удалось найти Staff.
    """


class PersonIsDismissed(AuthException):
    """
    Сотрудник уволен.
    """
