import logging
from datetime import datetime

from django.conf import settings
from django.utils.functional import SimpleLazyObject
from ids.storages.local_memory import LocalMemoryStorage

from staff.lib.requests import get_ids_repository


logger = logging.getLogger(__name__)


_calendar = SimpleLazyObject(
    lambda: get_ids_repository(
        service='calendar',
        user_agent=settings.STAFF_USER_AGENT,
        resource_type='holidays',
        storage=LocalMemoryStorage(),
    )
)


def get_holidays(start_date, end_date, geo_ids, out_mode='overrides'):
    if isinstance(start_date, datetime):
        start_date = start_date.date()
    if isinstance(end_date, datetime):
        end_date = end_date.date()

    result = {}

    for geo_id in set(geo_ids):
        if geo_id == 0:
            geo_id = 225
        result[geo_id] = _calendar.get({
            'start_date': start_date,
            'end_date': end_date,
            'who_am_i': 'staff',
            'country_id': geo_id,
            'out_mode': out_mode,
        })

    return result
