import yenv
from django.conf import settings

from staff.anketa.views import get_current_lang_ui


def settings_context(request):
    return settings._wrapped.__dict__


def current_language_code(request):
    if request and hasattr(request, 'user') and not request.user.is_anonymous():
        return {'LANGUAGE_CODE': get_current_lang_ui(request)}
    else:
        return {'LANGUAGE_CODE': settings.DEFAULT_LANG_UI}


def env(request):
    return {'ENV': yenv.type}
