from copy import deepcopy

from staff.lib.exceptions import ErrorWithStatusCode


def error(e_dict, params=None):
    result = deepcopy(e_dict)
    if params and 'params' in e_dict:
        for k, v in params.items():
            result['params'][k] = result['params'][k] % {k: v}
    return result


def general_error(e):
    return {'errors': [e]}


def default_error():
    return general_error(DEFAULT_GENERAL_ERROR)


def invalid_json_error(json):
    return general_error(error(INVALID_JSON_ERROR, params={'json': json}))


def form_data_error(form_name):
    return general_error(error(NO_FORM_DATA, params={'form': form_name}))


DEFAULT_GENERAL_ERROR = {'error_key': 'general-error'}

NO_DATA_PROVIDED = {'error_key': 'no-data-provided'}

INVALID_JSON_ERROR = {
    'error_key': 'general-error-invalid_json',
    'params': {
        'json': '%(json)s'
    }
}

NO_FORM_DATA = {
    'error_key': 'general-error-no_form_data',
    'params': {
        'form': '%(form)s'
    }
}


class LogException(object):

    def __init__(self, catch_e, logger, message, message_params, raise_e=None, status_code=None):
        assert raise_e is None or issubclass(raise_e, ErrorWithStatusCode), 'Unhandled exception type'
        self.catch_e = catch_e
        self.raise_e = raise_e
        self.status_code = status_code
        self.logger = logger
        self.message = message
        self.message_params = message_params

    def __enter__(self):
        pass

    def __exit__(self, exception_type, value, traceback):
        if exception_type == self.catch_e:
            self.logger.exception(self.message, *self.message_params)
            if self.raise_e:
                raise self.raise_e(value.message, self.status_code)
            else:
                raise value


def sform_general_error(err_code, params=None):
    return sform_single_field_error('', err_code, params)


def sform_single_field_error(field, err_code, params=None):
    result = {'errors': {field: [{'code': err_code}]}}
    if params:
        result['errors'][field][0]['params'] = params
    return result
