from datetime import date, datetime, time, timedelta
from decimal import Decimal
from functools import partial
from json import JSONEncoder as BaseJSONEncoder, dumps as base_dumps
import types

from django.utils.functional import Promise
from django.db.models import Model
from django.utils.encoding import force_text


class JSONEncoder(BaseJSONEncoder):
    def default(self, o):
        if isinstance(o, datetime):
            return o.isoformat()[:19]
        if isinstance(o, timedelta):
            return str(o)
        if isinstance(o, (time, date)):
            return o.isoformat()
        if isinstance(o, tuple(type(col) for col in [dict().keys(), dict().items(), dict().values()])):
            return list(o)
        if isinstance(o, Promise):
            return force_text(o)
        if isinstance(o, Model):
            return str(o.pk)
        if isinstance(o, set):
            return list(o)
        if isinstance(o, Decimal):
            return str(o)
        if isinstance(o, types.GeneratorType):
            return list(o)

        return super(JSONEncoder, self).default(o)


dumps = partial(base_dumps, cls=JSONEncoder)
