from django.core.management.base import BaseCommand
from django.utils.importlib import import_module


SNIPPETS_PACKAGE = 'staff.snippets'
DEFAULT_CALLABLE_NAME = 'run'


class Command(BaseCommand):
    help = "Runs scripts from snippets"

    def handle(self, *args, **options):
        self.parse_args(*args, **options)
        action = self.get_callable(module_name=self.module_name,
                                   action_name=self.action_name)

        try:
            action(verbosity=self.verbosity)
        except Exception as e:
            print(e)

    def parse_args(self, *args, **options):
        self.verbosity = int(options.get('verbosity'))

        if not args:
            print('You must specify scriptname')
            exit()
        callable_path = args[0]

        if '.' in callable_path:
            self.module_name, self.action_name = callable_path.split('.')
        else:
            self.module_name = callable_path
            self.action_name = DEFAULT_CALLABLE_NAME

    def get_callable(self, module_name, action_name):
        module = import_module(SNIPPETS_PACKAGE + '.' + module_name)
        if hasattr(module, action_name):
            return getattr(module, action_name)
        else:
            print('module %s has no action %s' % (module, action_name))
            exit()
