from django.utils import translation
from django.utils.cache import patch_vary_headers


class LanguageMiddleware:

    def process_request(self, request):
        # AuthMiddleware уже была вызвана ранее
        if hasattr(request.user, 'get_profile'):
            language = request.user.get_profile().lang_ui
            request.LANGUAGE_CODE = language
            translation.activate(language)

    def process_response(self, request, response):
        patch_vary_headers(response, ('Accept-Language',))
        if 'Content-Language' not in response:
            response['Content-Language'] = translation.get_language()
        translation.deactivate()
        return response
