import uuid

from staff.lib.deploy_log_variables import DEPLOY_VARIABLES
from staff.lib.log import log_context


class LogContextMiddleware(object):
    def process_request(self, request):
        context_vars = {
            'request_id': request.META.get('HTTP_X_REQ_ID', 'gen:{}'.format(uuid.uuid4())),
            'original_request_id': request.META.get('HTTP_X_ORIGINAL_REQUEST_ID', '?'),
        }
        context_vars.update(DEPLOY_VARIABLES)
        request.context = log_context(**context_vars).__enter__()

    def process_response(self, request, response):
        request.context.__exit__(None, None, None)
        return response
