import re
import os

from django.http import JsonResponse

from staff.monitorings import unistat


class UnistatResponseMiddleware:
    deploy_unit_id = os.getenv('DEPLOY_UNIT_ID')

    def process_request(self, request):
        if re.match(r'^/unistat/?$', request.path):
            if self.deploy_unit_id.startswith('back') or self.deploy_unit_id == 'profile-api':
                return JsonResponse(data=unistat.get_metrics_back(), safe=False)
            else:
                return JsonResponse(data=unistat.get_metrics(), safe=False)
