def warmup():
    from django.apps import apps
    from django.conf import settings
    from django.db import Error
    from django.views.decorators.http import require_http_methods # noqa ignore=F401
    from django.views.decorators.csrf import ensure_csrf_cookie # noqa ignore=F401

    from staff import urls # noqa ignore=F401
    from staff.lib import waffle
    from staff.lib.decorators import responding_json, use_request_lang, available_for_external # noqa ignore=F401
    from staff.person_profile.controllers.blocks.meta_blocks_registry import MetaBlocksRegistry # noqa ignore=F401
    from staff.person_profile.controllers.links_generator import LinksGenerator # noqa ignore=F401
    from staff.person_profile.controllers.search import find_person, get_search_url # noqa ignore=F401
    from staff.person_profile.permissions.utils import get_block_registry # noqa ignore=F401

    waffle.preload_all()

    if settings.DEPLOY_UNIT_ID in ('back', 'back-api', 'profile-api'):
        app_models = apps.get_models()
        print(f'{len(app_models)} models found.')

        for model in app_models:
            if not model._meta.managed or model._meta.abstract:
                continue

            try:
                model.objects.all().first()
            except Error:
                print(f'Failed on model {model}')
                raise

    return 'OK'
